/*
 * Decompiled with CFR 0.152.
 */
package br.edu.ifsp.hto.posEducacao;

import br.edu.ifsp.hto.posEducacao.ConfiguradorVagas;
import br.edu.ifsp.hto.posEducacao.InscritoVO;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class LeitorExcel {
    private static final String CONTEXT_PATH = System.getProperty("user.dir");
    private static final String EXCEL_FILE_NAME = "\\inscricoes2025_sorteio.xlsx";

    public ArrayList<InscritoVO> lendoExcel() {
        ArrayList<InscritoVO> listaInscrito = new ArrayList<InscritoVO>();
        String numeroInsc = "";
        int numeroSorteio = 0;
        String nome = "";
        String categoria = "";
        boolean prioridade = false;
        try {
            FileInputStream arquivoExcel = new FileInputStream(String.valueOf(CONTEXT_PATH) + EXCEL_FILE_NAME);
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)arquivoExcel);
            XSSFSheet sheet = workbook.getSheetAt(0);
            int rowStart = Integer.parseInt(ConfiguradorVagas.linhaInicio);
            int rowEnd = Integer.parseInt(ConfiguradorVagas.linhaFim);
            int rowNum = rowStart;
            while (rowNum < rowEnd) {
                XSSFRow r = sheet.getRow(rowNum);
                if (r != null) {
                    int firstColumn = Integer.parseInt(ConfiguradorVagas.colunaInicio);
                    int lastColumn = Integer.parseInt(ConfiguradorVagas.colunaFim);
                    int coluna = firstColumn;
                    while (coluna <= lastColumn) {
                        Cell cell = r.getCell(coluna);
                        if (coluna == 0) {
                            numeroInsc = cell.getStringCellValue();
                        }
                        if (coluna == 1) {
                            nome = cell.getStringCellValue();
                        }
                        if (coluna == 2) {
                            categoria = cell.getStringCellValue();
                        }
                        if (coluna == 3) {
                            prioridade = cell.getStringCellValue().equals("SIM");
                        }
                        if (coluna == 4) {
                            numeroSorteio = (int)cell.getNumericCellValue();
                        }
                        ++coluna;
                    }
                    listaInscrito.add(new InscritoVO(numeroInsc, numeroSorteio, nome, categoria, prioridade));
                }
                ++rowNum;
            }
            arquivoExcel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listaInscrito;
    }

    public static void main(String[] args) {
        LeitorExcel leitor = new LeitorExcel();
        leitor.lendoExcel();
    }
}

