/*
 * Decompiled with CFR 0.152.
 */
package br.edu.ifsp.hto.posEducacao;

import br.edu.ifsp.hto.posEducacao.ConfiguradorVagas;
import br.edu.ifsp.hto.posEducacao.InscritoVO;
import br.edu.ifsp.hto.posEducacao.Listas;
import br.edu.ifsp.hto.posEducacao.SorteadorPosFrame;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.swing.JOptionPane;

public class SorteadorPos {
    private long semente = 0L;
    public static final String AMPLA = "AMPLA";
    public static final String PPI = "PPI";
    public static final String PCD = "PCD";
    public static final String QUILOMBOLA = "QUILOMBOLA";
    private Listas listas;
    private SorteadorPosFrame sorteadorFrame;
    private Random random;

    public SorteadorPos(SorteadorPosFrame sorteadorFrame) {
        this.sorteadorFrame = sorteadorFrame;
        ConfiguradorVagas.carregaPropriedades();
        this.listas = new Listas();
    }

    public Listas obterLista() {
        return this.listas;
    }

    public long getSemente() {
        if (this.semente == 0L) {
            this.defineSemente();
        }
        JOptionPane.showMessageDialog(this.sorteadorFrame, this.semente);
        return this.semente;
    }

    public boolean sortear() {
        JOptionPane.showMessageDialog(this.sorteadorFrame, "semente " + this.semente);
        this.random = new Random(this.semente);
        if (this.listas.getInscritoLista().size() <= Integer.parseInt(ConfiguradorVagas.qtdVagaTotal)) {
            return false;
        }
        this.geraAmplaSorteioLista();
        this.geraPPISorteioLista();
        this.geraPCDSorteioLista();
        this.geraQuilombolaSorteioLista();
        return true;
    }

    private void geraAmplaSorteioLista() {
        int indexUltimoPrioritario = -1;
        int qtdVagas = Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla);
        int qtdIscritos = this.listas.getAmplaInscritoLista().size();
        int qtdSorteados = 0;
        JOptionPane.showMessageDialog(this.sorteadorFrame, " Vagas Ampla = " + qtdVagas + " Inscritos = " + this.listas.getAmplaInscritoLista().size());
        while (qtdSorteados < qtdIscritos) {
            int numeroSorteadoAmpla = this.random.nextInt(this.listas.getAmplaInscritoLista().size());
            InscritoVO sorteadoVO = this.listas.getAmplaInscritoLista().get(numeroSorteadoAmpla);
            if (this.listas.getAmplaSorteioLista().isEmpty()) {
                if (sorteadoVO.isPrioridade()) {
                    ++indexUltimoPrioritario;
                }
                this.listas.getAmplaSorteioLista().add(sorteadoVO);
                ++qtdSorteados;
                continue;
            }
            if (this.listas.getAmplaSorteioLista().contains(sorteadoVO)) continue;
            ++qtdSorteados;
            if (sorteadoVO.isPrioridade()) {
                this.listas.getAmplaSorteioLista().add(++indexUltimoPrioritario, sorteadoVO);
                continue;
            }
            this.listas.getAmplaSorteioLista().add(sorteadoVO);
        }
        this.mostra(this.listas.getAmplaSorteioLista());
    }

    private void geraPPISorteioLista() {
        int indexUltimoPrioritario = -1;
        int qtdVagas = Integer.parseInt(ConfiguradorVagas.qtdVagaPPI);
        int qtdIscritos = this.listas.getpPIInscritoLista().size();
        int qtdSorteados = 0;
        ArrayList<InscritoVO> pPIiscritoListaTemp = new ArrayList<InscritoVO>(this.listas.getpPIInscritoLista());
        JOptionPane.showMessageDialog(this.sorteadorFrame, " Vagas PPI = " + qtdVagas + " Inscritos = " + this.listas.getpPIInscritoLista().size());
        while (!pPIiscritoListaTemp.isEmpty() && qtdSorteados < qtdIscritos) {
            int numeroSorteadoPPI = this.random.nextInt(this.listas.getpPIInscritoLista().size());
            InscritoVO sorteadoVO = this.listas.getpPIInscritoLista().get(numeroSorteadoPPI);
            int posicaoListaAmpla = this.listas.getAmplaSorteioLista().indexOf(sorteadoVO);
            if (posicaoListaAmpla < Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla)) {
                pPIiscritoListaTemp.remove(sorteadoVO);
                continue;
            }
            if (this.listas.getpPISorteioLista().isEmpty()) {
                if (sorteadoVO.isPrioridade()) {
                    ++indexUltimoPrioritario;
                }
                this.listas.getpPISorteioLista().add(sorteadoVO);
                pPIiscritoListaTemp.remove(sorteadoVO);
                ++qtdSorteados;
                continue;
            }
            if (!this.listas.getpPISorteioLista().contains(sorteadoVO)) {
                ++qtdSorteados;
                if (sorteadoVO.isPrioridade()) {
                    this.listas.getpPISorteioLista().add(++indexUltimoPrioritario, sorteadoVO);
                } else {
                    this.listas.getpPISorteioLista().add(sorteadoVO);
                }
            }
            pPIiscritoListaTemp.remove(sorteadoVO);
        }
        this.mostra(this.listas.getpPISorteioLista());
    }

    private void geraPCDSorteioLista() {
        int indexUltimoPrioritario = -1;
        int qtdVagas = Integer.parseInt(ConfiguradorVagas.qtdVagaPCD);
        int qtdIscritos = this.listas.getpCDInscritoLista().size();
        int qtdSorteados = 0;
        ArrayList<InscritoVO> pCDiscritoListaTemp = new ArrayList<InscritoVO>(this.listas.getpCDInscritoLista());
        JOptionPane.showMessageDialog(this.sorteadorFrame, " Vagas PCD = " + qtdVagas + " Inscritos = " + this.listas.getpCDInscritoLista().size());
        while (!pCDiscritoListaTemp.isEmpty() && qtdSorteados < qtdIscritos) {
            int numeroSorteadoPCD = this.random.nextInt(this.listas.getpCDInscritoLista().size());
            InscritoVO sorteadoVO = this.listas.getpCDInscritoLista().get(numeroSorteadoPCD);
            int posicaoListaAmpla = this.listas.getAmplaSorteioLista().indexOf(sorteadoVO);
            if (posicaoListaAmpla < Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla)) {
                pCDiscritoListaTemp.remove(sorteadoVO);
                continue;
            }
            if (this.listas.getpCDInscritoLista().isEmpty()) {
                if (sorteadoVO.isPrioridade()) {
                    ++indexUltimoPrioritario;
                }
                this.listas.getpCDSorteioLista().add(sorteadoVO);
                pCDiscritoListaTemp.remove(sorteadoVO);
                ++qtdSorteados;
                continue;
            }
            if (!this.listas.getpCDSorteioLista().contains(sorteadoVO)) {
                ++qtdSorteados;
                if (sorteadoVO.isPrioridade()) {
                    this.listas.getpCDSorteioLista().add(++indexUltimoPrioritario, sorteadoVO);
                } else {
                    this.listas.getpCDSorteioLista().add(sorteadoVO);
                }
            }
            pCDiscritoListaTemp.remove(sorteadoVO);
        }
        this.mostra(this.listas.getpCDSorteioLista());
    }

    private void geraQuilombolaSorteioLista() {
        int indexUltimoPrioritario = -1;
        int qtdVagas = Integer.parseInt(ConfiguradorVagas.qtdVagaQuilombola);
        int qtdIscritos = this.listas.getQuilombolaInscritoLista().size();
        int qtdSorteados = 0;
        ArrayList<InscritoVO> quiLombolaInscritoListaTemp = new ArrayList<InscritoVO>(this.listas.getQuilombolaInscritoLista());
        JOptionPane.showMessageDialog(this.sorteadorFrame, " Vagas Quilombola = " + qtdVagas + " Inscritos = " + this.listas.getQuilombolaInscritoLista().size());
        while (!quiLombolaInscritoListaTemp.isEmpty() && qtdSorteados < qtdIscritos) {
            int numeroSorteadoQuil = this.random.nextInt(this.listas.getQuilombolaInscritoLista().size());
            InscritoVO sorteadoVO = this.listas.getQuilombolaInscritoLista().get(numeroSorteadoQuil);
            int posicaoListaAmpla = this.listas.getAmplaSorteioLista().indexOf(sorteadoVO);
            if (posicaoListaAmpla < Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla)) {
                quiLombolaInscritoListaTemp.remove(sorteadoVO);
                continue;
            }
            if (this.listas.getQuilombolaInscritoLista().isEmpty()) {
                if (sorteadoVO.isPrioridade()) {
                    ++indexUltimoPrioritario;
                }
                this.listas.getQuilombolaInscritoLista().add(sorteadoVO);
                quiLombolaInscritoListaTemp.remove(sorteadoVO);
                ++qtdSorteados;
                continue;
            }
            if (!this.listas.getQuilombolaSorteioLista().contains(sorteadoVO)) {
                ++qtdSorteados;
                if (sorteadoVO.isPrioridade()) {
                    this.listas.getQuilombolaSorteioLista().add(++indexUltimoPrioritario, sorteadoVO);
                } else {
                    this.listas.getQuilombolaSorteioLista().add(sorteadoVO);
                }
            }
            quiLombolaInscritoListaTemp.remove(sorteadoVO);
        }
        this.mostra(this.listas.getQuilombolaSorteioLista());
    }

    public void listar() {
        this.geraAmplaMatriculaListaEEspera();
        this.geraPPIMatriculaListaEEspera();
        this.geraPCDMatriculaListaEEspera();
        this.geraQuilombolaMatriculaListaEEspera();
    }

    private void geraQuilombolaMatriculaListaEEspera() {
        InscritoVO sorteado;
        int i = 0;
        while (i < Integer.parseInt(ConfiguradorVagas.qtdVagaQuilombola)) {
            if (i < this.listas.getQuilombolaSorteioLista().size()) {
                sorteado = this.listas.getQuilombolaSorteioLista().get(i);
                this.listas.getQuilombolaMatriculaLista().add(sorteado);
            }
            ++i;
        }
        i = Integer.parseInt(ConfiguradorVagas.qtdVagaQuilombola);
        while (i < this.listas.getQuilombolaSorteioLista().size()) {
            sorteado = this.listas.getQuilombolaSorteioLista().get(i);
            this.listas.getQuilombolaMatriculaEsperaLista().add(sorteado);
            ++i;
        }
    }

    private void geraPCDMatriculaListaEEspera() {
        InscritoVO sorteado;
        if (this.listas.getpCDSorteioLista().isEmpty()) {
            return;
        }
        int i = 0;
        while (i < Integer.parseInt(ConfiguradorVagas.qtdVagaPCD)) {
            if (i < this.listas.getpCDSorteioLista().size()) {
                sorteado = this.listas.getpCDSorteioLista().get(i);
                this.listas.getpCDmatriculaLista().add(sorteado);
            }
            ++i;
        }
        i = Integer.parseInt(ConfiguradorVagas.qtdVagaPCD);
        while (i < this.listas.getpCDSorteioLista().size()) {
            sorteado = this.listas.getpCDSorteioLista().get(i);
            this.listas.getpCDmatriculaEsperaLista().add(sorteado);
            ++i;
        }
    }

    private void geraPPIMatriculaListaEEspera() {
        InscritoVO sorteado;
        int i = 0;
        while (i < Integer.parseInt(ConfiguradorVagas.qtdVagaPPI)) {
            if (i < this.listas.getpPISorteioLista().size()) {
                sorteado = this.listas.getpPISorteioLista().get(i);
                this.listas.getpPIMatriculaLista().add(sorteado);
            }
            ++i;
        }
        i = Integer.parseInt(ConfiguradorVagas.qtdVagaPPI);
        while (i < this.listas.getpPISorteioLista().size()) {
            sorteado = this.listas.getpPISorteioLista().get(i);
            this.listas.getpPIMatriculaEsperaLista().add(sorteado);
            ++i;
        }
    }

    private void geraAmplaMatriculaListaEEspera() {
        InscritoVO sorteado;
        int i = 0;
        while (i < Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla)) {
            sorteado = this.listas.getAmplaSorteioLista().get(i);
            this.listas.getAmplaMatriculaLista().add(sorteado);
            ++i;
        }
        i = Integer.parseInt(ConfiguradorVagas.qtdVagaAmpla);
        while (i < this.listas.getAmplaSorteioLista().size()) {
            sorteado = this.listas.getAmplaSorteioLista().get(i);
            this.listas.getAmplaMatriculaEsperaLista().add(sorteado);
            ++i;
        }
    }

    private void mostra(ArrayList<InscritoVO> lista) {
        int posicao = 0;
        System.out.print("\n posicao  inscricao  Categoria Prioridade");
        for (InscritoVO i : lista) {
            System.out.print("\n\t" + posicao + "\t" + i.getNumeroInsc() + "\t" + i.getCategoria() + "\t" + i.isPrioridade());
            ++posicao;
        }
    }

    private long defineSemente() {
        if (this.sorteadorFrame.getSementeTextField().isEmpty()) {
            Date dataAtual = new Date();
            this.semente = dataAtual.getTime();
        } else {
            this.semente = Long.parseLong(this.sorteadorFrame.getSementeTextField());
        }
        return this.semente;
    }
}

