/*
 * Decompiled with CFR 0.152.
 */
package br.edu.ifsp.hto.posEducacao;

import br.edu.ifsp.hto.posEducacao.GravadorArquivo;
import br.edu.ifsp.hto.posEducacao.InscritoVO;
import br.edu.ifsp.hto.posEducacao.Listas;
import br.edu.ifsp.hto.posEducacao.SorteadorPos;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SorteadorPosFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JLabel labelTotalInscritoValido;
    private JLabel labelTInscritoPrio;
    private JLabel labelTotalInscritoQuilombola;
    private JLabel labelTotalInscritoPrioQuilombola;
    private JLabel labelTotalInscritoPPI;
    private JLabel labelTotalInscritoPrioPPI;
    private JLabel labelTotalInscritoPCN;
    private JLabel labelTotalInscritoPrioPCN;
    private JLabel labelSemente;
    private JLabel textTotalInscritoValido;
    private JLabel textTInscritoPrio;
    private JLabel textTotalInscritoQuilombola;
    private JLabel textTotalInscritoPrioQuilombola;
    private JLabel textTotalInscritoPPI;
    private JLabel textTotalInscritoPrioPPI;
    private JLabel textTotalInscritoPCD;
    private JLabel textTotalInscritoPrioPCD;
    private JTextField textSementeGerada;
    private JTextArea areaListaMatriculaAmpla;
    private JTextArea areaListaEsperaMatriculaAmpla;
    private JTextArea areaListaMatriculaPPI;
    private JTextArea areaListaEsperaMatriculaPPI;
    private JTextArea areaListaMatriculaPCD;
    private JTextArea areaListaEsperaMatriculaPCD;
    private JTextArea areaListaMatriculaQuilombola;
    private JTextArea areaListaEsperaMatriculaQuilombola;
    private JScrollPane scrollListaMatriculaAmpla;
    private JScrollPane scrollListaEsperaMatriculaAmpla;
    private JScrollPane scrollListaMatriculaPPI;
    private JScrollPane scrollListaEsperaMatriculaPPI;
    private JScrollPane scrollListaMatriculaPCD;
    private JScrollPane scrollListaEsperaMatriculaPCD;
    private JScrollPane scrollListaMatriculaQuilombola;
    private JScrollPane scrollListaEsperaMatriculaQuilombola;
    private JButton botaoSortear;
    private JButton botaoListaMatricula;
    private SorteadorPos sorteadorPos = new SorteadorPos(this);
    private boolean sorteioOcorreu = false;
    private Listas listas = this.sorteadorPos.obterLista();

    public SorteadorPosFrame() {
        super("Sorteador P\u00f3s Ens. B\u00e1sico ");
        this.iniciaComponentes();
        this.montaTela();
        this.tratamentoBotaoSorteio();
        this.tratamentoBotaoLista();
    }

    private void tratamentoBotaoLista() {
        this.botaoListaMatricula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SorteadorPosFrame.this.sorteioOcorreu) {
                    SorteadorPosFrame.this.listar();
                    SorteadorPosFrame.this.botaoListaMatricula.setEnabled(false);
                    return;
                }
            }
        });
    }

    private void tratamentoBotaoSorteio() {
        this.botaoSortear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SorteadorPosFrame.this.textSementeGerada.setText(String.valueOf(SorteadorPosFrame.this.sorteadorPos.getSemente()));
                if (!SorteadorPosFrame.this.sorteadorPos.sortear()) {
                    JOptionPane.showMessageDialog(SorteadorPosFrame.this, "A quantidade de inscritos menor que a quantidade de vagas.Ir direto para a listagem");
                }
                SorteadorPosFrame.this.botaoSortear.setEnabled(false);
                SorteadorPosFrame.this.botaoListaMatricula.setEnabled(true);
                SorteadorPosFrame.this.sorteioOcorreu = true;
            }
        });
    }

    private void listar() {
        this.sorteadorPos.listar();
        this.mostraTextArea(this.areaListaMatriculaAmpla, this.sorteadorPos.obterLista().getAmplaMatriculaLista());
        this.mostraTextArea(this.areaListaEsperaMatriculaAmpla, this.sorteadorPos.obterLista().getAmplaMatriculaEsperaLista());
        this.mostraTextArea(this.areaListaMatriculaPPI, this.sorteadorPos.obterLista().getpPIMatriculaLista());
        this.mostraTextArea(this.areaListaEsperaMatriculaPPI, this.sorteadorPos.obterLista().getpPIMatriculaEsperaLista());
        this.mostraTextArea(this.areaListaMatriculaPCD, this.sorteadorPos.obterLista().getpCDmatriculaLista());
        this.mostraTextArea(this.areaListaEsperaMatriculaPCD, this.sorteadorPos.obterLista().getpCDmatriculaEsperaLista());
        this.mostraTextArea(this.areaListaMatriculaQuilombola, this.sorteadorPos.obterLista().getQuilombolaMatriculaLista());
        this.mostraTextArea(this.areaListaEsperaMatriculaQuilombola, this.sorteadorPos.obterLista().getQuilombolaMatriculaEsperaLista());
        this.escreveArquivo(this.areaListaMatriculaAmpla, "ListaMatriculaAmpla");
        this.escreveArquivo(this.areaListaEsperaMatriculaAmpla, "ListaEsperaMatriculaAmpla");
        this.escreveArquivo(this.areaListaMatriculaPPI, "ListaMatriculaPPI");
        this.escreveArquivo(this.areaListaEsperaMatriculaPPI, "ListaEsperaMatriculaPPI");
        this.escreveArquivo(this.areaListaMatriculaPCD, "ListaMatriculaPCD");
        this.escreveArquivo(this.areaListaEsperaMatriculaPCD, "ListaEsperaMatriculaPCD");
        this.escreveArquivo(this.areaListaMatriculaQuilombola, "ListaMatriculaQuilombola");
        this.escreveArquivo(this.areaListaEsperaMatriculaQuilombola, "ListaEsperaMatriculaQuilombola");
    }

    private void escreveArquivo(JTextArea area, String nomeArquivo) {
        GravadorArquivo gravando = new GravadorArquivo();
        gravando.escrevendo(area, nomeArquivo);
    }

    private void mostraTextArea(JTextArea textArea, ArrayList<InscritoVO> lista) {
        String texto = textArea.getText();
        texto = String.valueOf(texto) + "\nN.Inscric\u00e3o\tNome\t\tCat.\tPrior.\tN.Sorteio";
        for (InscritoVO matricula : lista) {
            texto = String.valueOf(texto) + "\n " + matricula.getNumeroInsc() + "\t" + matricula.getNome() + "\t" + matricula.getCategoria();
            texto = matricula.isPrioridade() ? String.valueOf(texto) + "\tSIM" : String.valueOf(texto) + "\tN\u00c3O";
            texto = String.valueOf(texto) + "\t" + matricula.getNumeroSorteio();
        }
        textArea.setText(texto);
    }

    private void montaTela() {
        this.add(this.labelTotalInscritoValido);
        this.add(this.textTotalInscritoValido);
        this.add(this.labelTInscritoPrio);
        this.add(this.textTInscritoPrio);
        this.add(this.labelTotalInscritoQuilombola);
        this.add(this.textTotalInscritoQuilombola);
        this.add(this.labelTotalInscritoPrioQuilombola);
        this.add(this.textTotalInscritoPrioQuilombola);
        this.add(this.labelTotalInscritoPPI);
        this.add(this.textTotalInscritoPPI);
        this.add(this.labelTotalInscritoPrioPPI);
        this.add(this.textTotalInscritoPrioPPI);
        this.add(this.labelTotalInscritoPCN);
        this.add(this.textTotalInscritoPCD);
        this.add(this.labelTotalInscritoPrioPCN);
        this.add(this.textTotalInscritoPrioPCD);
        this.add(this.labelSemente);
        this.add(this.textSementeGerada);
        this.add(this.botaoSortear);
        this.add(this.botaoListaMatricula);
        this.add(this.scrollListaMatriculaAmpla);
        this.add(this.scrollListaEsperaMatriculaAmpla);
        this.add(this.scrollListaMatriculaPPI);
        this.add(this.scrollListaEsperaMatriculaPPI);
        this.add(this.scrollListaMatriculaPCD);
        this.add(this.scrollListaEsperaMatriculaPCD);
        this.add(this.scrollListaMatriculaQuilombola);
        this.add(this.scrollListaEsperaMatriculaQuilombola);
    }

    public String getSementeTextField() {
        return this.textSementeGerada.getText();
    }

    private void iniciaComponentes() {
        this.setLayout(new FlowLayout());
        this.labelTotalInscritoValido = new JLabel("-Insc. Homologados:");
        this.labelTInscritoPrio = new JLabel("-Insc. Priorit\u00e1rios Ampla:");
        this.labelTotalInscritoQuilombola = new JLabel("-Insc. Quilombolas:");
        this.labelTotalInscritoPrioQuilombola = new JLabel("-Insc. Prior. Quilombolas:");
        this.labelTotalInscritoPPI = new JLabel("-Insc. PPI:");
        this.labelTotalInscritoPrioPPI = new JLabel("-Insc. Prior PPI:");
        this.labelTotalInscritoPCN = new JLabel("-Insc. PCD:");
        this.labelTotalInscritoPrioPCN = new JLabel("-Insc. Prior PCD:");
        this.labelSemente = new JLabel("Semente Geradora do Sorteio");
        this.textTotalInscritoValido = new JLabel("" + this.listas.getAmplaInscritoLista().size());
        this.textTInscritoPrio = new JLabel("" + this.listas.getQtdAmplaPrioInscritoLista());
        this.textTotalInscritoQuilombola = new JLabel("" + this.listas.getQuilombolaInscritoLista().size());
        this.textTotalInscritoPrioQuilombola = new JLabel("" + this.listas.getQtdQuilombolaPrioInscritoLista());
        this.textTotalInscritoPPI = new JLabel("" + this.listas.getpPIInscritoLista().size());
        this.textTotalInscritoPrioPPI = new JLabel("" + this.listas.getpQtdPIPrioInscritoLista());
        this.textTotalInscritoPCD = new JLabel("" + this.listas.getpCDInscritoLista().size());
        this.textTotalInscritoPrioPCD = new JLabel("" + this.listas.getQtdPCDPrioInscritoLista());
        this.textSementeGerada = new JTextField("", 30);
        this.botaoSortear = new JButton("Sortear Inscritos");
        this.botaoListaMatricula = new JButton("Mostrar Listas Matr\u00edculas");
        this.areaListaMatriculaAmpla = new JTextArea("Lista Matr\u00edcula Ampla", 25, 25);
        this.scrollListaMatriculaAmpla = new JScrollPane(this.areaListaMatriculaAmpla);
        this.scrollListaMatriculaAmpla.setSize(30, 25);
        this.areaListaEsperaMatriculaAmpla = new JTextArea("Lista Espera Ampla", 25, 25);
        this.scrollListaEsperaMatriculaAmpla = new JScrollPane(this.areaListaEsperaMatriculaAmpla);
        this.scrollListaEsperaMatriculaAmpla.setSize(30, 25);
        this.areaListaMatriculaPPI = new JTextArea("Lista Matr\u00edcula PPI", 25, 25);
        this.scrollListaMatriculaPPI = new JScrollPane(this.areaListaMatriculaPPI);
        this.scrollListaMatriculaPPI.setSize(30, 25);
        this.areaListaEsperaMatriculaPPI = new JTextArea("Lista Espera PPI", 25, 25);
        this.scrollListaEsperaMatriculaPPI = new JScrollPane(this.areaListaEsperaMatriculaPPI);
        this.scrollListaEsperaMatriculaPPI.setSize(30, 25);
        this.areaListaMatriculaPCD = new JTextArea("Lista Matr\u00edcula PCD", 20, 25);
        this.scrollListaMatriculaPCD = new JScrollPane(this.areaListaMatriculaPCD);
        this.scrollListaMatriculaPCD.setSize(30, 25);
        this.areaListaEsperaMatriculaPCD = new JTextArea("Lista Espera PCD", 20, 25);
        this.scrollListaEsperaMatriculaPCD = new JScrollPane(this.areaListaEsperaMatriculaPCD);
        this.scrollListaEsperaMatriculaPCD.setSize(30, 25);
        this.areaListaMatriculaQuilombola = new JTextArea("Lista Matr\u00edcula Quilombola", 20, 25);
        this.scrollListaMatriculaQuilombola = new JScrollPane(this.areaListaMatriculaQuilombola);
        this.scrollListaMatriculaQuilombola.setSize(30, 25);
        this.areaListaEsperaMatriculaQuilombola = new JTextArea("Lista Espera Quilombola", 20, 25);
        this.scrollListaEsperaMatriculaQuilombola = new JScrollPane(this.areaListaEsperaMatriculaQuilombola);
        this.scrollListaEsperaMatriculaQuilombola.setSize(30, 25);
        this.botaoListaMatricula.setEnabled(false);
    }
}

